import pickle 
import numpy as np  
import pandas as pd 

def compare_dicts(ai_output, reference_output):  
    # Compare trend results  
    for metric in ai_output.keys():  
        if not np.isclose(ai_output[metric], reference_output[metric]):  
            return False  
    return True

# Replace <ai_res> and <ref_res> with the actual AI and reference outputs
try:
    with open("pred_result/summary.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = None

with open("ref_result/summary.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

# Call the satisfies_user_requirements function with both outputs
try:
    result = compare_dicts(machine_result, reference_result)
except:
    result = False

print(result)

